unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, ComCtrls, ExtCtrls, IniFiles, Menus, ClipBrd;

type
  TASCIICodeMain = class(TForm)
    StringGrid1: TStringGrid;
    StatusBar1: TStatusBar;
    ColorDialog1: TColorDialog;
    FontDialog1: TFontDialog;
    PopupMenu1: TPopupMenu;
    HexCmd: TMenuItem;
    DecCmd: TMenuItem;
    OctCmd: TMenuItem;
    BinCmd: TMenuItem;
    StrCmd: TMenuItem;
    ExpCmd: TMenuItem;
    JpnCmd: TMenuItem;
    ChrCmd: TMenuItem;
    MixCmd: TMenuItem;
    N1: TMenuItem;
    VerticalCmd: TMenuItem;
    EightBitsCmd: TMenuItem;
    ColorCmd: TMenuItem;
    FontCmd: TMenuItem;
    GenerateCmd: TMenuItem;
    VersionCmd: TMenuItem;
    CopyrightCmd: TMenuItem;
    ExitCmd: TMenuItem;
    N4: TMenuItem;
    FixedColorCmd: TMenuItem;
    RawCodeCmd: TMenuItem;
    PreferenceCmd: TMenuItem;
    N5: TMenuItem;
    N3: TMenuItem;
    N2: TMenuItem;
    UseExplainECmd: TMenuItem;
    UseExplainJCmd: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure StringGrid1SelectCell(Sender: TObject; Col, Row: Integer;
      var CanSelect: Boolean);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MenuItem1Click(Sender: TObject);
    procedure FontCmdClick(Sender: TObject);
    procedure FontDialog1Apply(Sender: TObject; Wnd: HWND);
    procedure StringGrid1DrawCell(Sender: TObject; Col, Row: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure GenerateCmdClick(Sender: TObject);
    procedure ExitCmdClick(Sender: TObject);
    procedure StringGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure VerticalCmdClick(Sender: TObject);
    procedure EightBitsCmdClick(Sender: TObject);
    procedure ColorCmdClick(Sender: TObject);
    procedure FixedColorCmdClick(Sender: TObject);
    procedure RawCodeCmdClick(Sender: TObject);
  private
    procedure SetMenuItemStr(LN,HN: Integer);
    procedure ShowStatus(H,D,O,B,S: string);
    procedure AdjustFormSize;
    procedure ExportTables;
    procedure ImportTables;
    procedure SetupGrids(bFirstTime: Boolean);
  public
  end;

var
  ASCIICodeMain: TASCIICodeMain;

implementation

{$R *.DFM}

const
  TableLines = 128; //s

type
  TExplanationTable = array[0..TableLines-1]of string;

const
  ExplanationTableEDefault: TExplanationTable = (
{00}'NULL','START OF HEADING','START OF TEXT','END OF TEXT',
{04}'END OF TRANSMISSION','ENQUIRY','ACKNOWLEDGE','BELL',
                {HORIZONTAL TABULATION}{NEW LINE(NL)}
{08}'BACKSPACE','CHARACTER TABULATION','LINE FEED',
 {VERTICAL TABULATION}{NEW PAGE(NP)}
{0B}'LINE TABULATION','FORM FEED',
{0D}'CARRIAGE RETURN','SHIFT OUT','SHIFT IN','DATALINK ESCAPE',
{11}'DEVICE CONTROL ONE','DEVICE CONTROL TWO','DEVICE CONTROL THREE',
{14}'DEVICE CONTROL FOUR','NEGATIVE ACKNOWLEDGE','SYNCHRONOUS IDLE',
{17}'END OF TRANSMISSION BLOCK','CANCEL','END OF MEDIUM',
{1A}'SUBSTITUTE','ESCAPE','FILE SEPARATOR',
{1D}'GROUP SEPARATOR','RECORD SEPARATOR','UNIT SEPARATOR','SPACE',
{21}'EXCLAMATION MARK','QUOTATION MARK','NUMBER SIGN','DOLLAR SIGN',
{25}'PERCENT SIGN','AMPERSAND','APOSTROPHE','LEFT PARENTHESIS',
{29}'RIGHT PARENTHESIS','ASTERISK','PLUS SIGN','COMMA','HYPHEN-MINUS',
{2E}'FULL STOP','SOLIDUS','DIGIT ZERO','DIGIT ONE','DIGIT TWO',
{33}'DIGIT THREE','DIGIT FOUR','DIGIT FIVE','DIGIT SIX','DIGIT SEVEN',
{38}'DIGIT EIGHT','DIGIT NINE','COLON','SEMICOLON','LESS-THAN SIGN',
{3D}'EQUALS SIGN','GREATER-THAN SIGN','QUESTION MARK','COMMERCIAL AT',
{41}'LATIN CAPITAL LETTER A','LATIN CAPITAL LETTER B',
{43}'LATIN CAPITAL LETTER C','LATIN CAPITAL LETTER D',
{45}'LATIN CAPITAL LETTER E','LATIN CAPITAL LETTER F',
{47}'LATIN CAPITAL LETTER G','LATIN CAPITAL LETTER H',
{49}'LATIN CAPITAL LETTER I','LATIN CAPITAL LETTER J',
{4B}'LATIN CAPITAL LETTER K','LATIN CAPITAL LETTER L',
{4D}'LATIN CAPITAL LETTER M','LATIN CAPITAL LETTER N',
{4F}'LATIN CAPITAL LETTER O','LATIN CAPITAL LETTER P',
{51}'LATIN CAPITAL LETTER Q','LATIN CAPITAL LETTER R',
{53}'LATIN CAPITAL LETTER S','LATIN CAPITAL LETTER T',
{55}'LATIN CAPITAL LETTER U','LATIN CAPITAL LETTER V',
{57}'LATIN CAPITAL LETTER W','LATIN CAPITAL LETTER X',
{59}'LATIN CAPITAL LETTER Y','LATIN CAPITAL LETTER Z',
{5B}'LEFT SQUARE BRACKET','REVERSE SOLIDUS',
{5D}'RIGHT SQUARE BRACKET','CIRCUMFLEX ACCENT',
{5F}'LOW LINE','GRAVE ACCENT',
{61}'LATIN SMALL LETTER A','LATIN SMALL LETTER B',
{63}'LATIN SMALL LETTER C','LATIN SMALL LETTER D',
{65}'LATIN SMALL LETTER E','LATIN SMALL LETTER F',
{67}'LATIN SMALL LETTER G','LATIN SMALL LETTER H',
{69}'LATIN SMALL LETTER I','LATIN SMALL LETTER J',
{6B}'LATIN SMALL LETTER K','LATIN SMALL LETTER L',
{6D}'LATIN SMALL LETTER M','LATIN SMALL LETTER N',
{6F}'LATIN SMALL LETTER O','LATIN SMALL LETTER P',
{71}'LATIN SMALL LETTER Q','LATIN SMALL LETTER R',
{73}'LATIN SMALL LETTER S','LATIN SMALL LETTER T',
{75}'LATIN SMALL LETTER U','LATIN SMALL LETTER V',
{77}'LATIN SMALL LETTER W','LATIN SMALL LETTER X',
{79}'LATIN SMALL LETTER Y','LATIN SMALL LETTER Z',
{7B}'LEFT CURLY BRACKET','VERTICAL LINE','RIGHT CURLY BRACKET',
{7E}'TILDE','DELETE'
  );
  ExplanationTableJDefault: TExplanationTable = (
{00}'k','wb_̎n܂','eLXg̎n܂','eLXg̏I',
{04}'`̏I','₢킹','m艞','r[v',
{08}'obNXy[X','^u','s',
{0B}'^u','y[W',
{0D}'A','VtgAEg','VtgC','`g',
{11}'u䕶P','u䕶Q','u䕶R',
{14}'u䕶S','ے艞','M',
{17}'ubN`I','','}̏I[',
{1A}'u','GXP[v','t@CZp[^',
{1D}'O[vZp[^','R[hZp[^','jbgZp[^','󔒕',
{21}'Q','p','ԍL','hL',
{25}'p[Zg','ApTh','Pp','JbRAۃJbR',
{29}'EJbRAEۃJbR','AXeXN','','J}','AnCt',
{2E}'sIhAhbg','ΐ','O','P','Q',
{33}'R','S','T','U','V',
{38}'W','X','R','Z~R','s(菬)',
{3D}'','s()','^╄','PL',
{41}'p啶`','p啶a','p啶b','p啶c',
{45}'p啶d','p啶e','p啶f','p啶g',
{49}'p啶h','p啶i','p啶j','p啶k',
{4D}'p啶l','p啶m','p啶n','p啶o',
{51}'p啶p','p啶q','p啶r','p啶s',
{55}'p啶t','p啶u','p啶v','p啶w',
{59}'p啶x','p啶y',
{5B}'JbR','~L',
{5D}'EJbR','ANTVRtbNX',
{5F}'L','ANTO[u',
{61}'p`','pa','pb','pc',
{65}'pd','pe','pf','pg',
{69}'ph','pi','pj','pk',
{6D}'pl','pm','pn','po',
{71}'pp','pq','pr','ps',
{75}'pt','pu','pv','pw',
{79}'px','py',
{7B}'JbR','c','EJbR',
{7E}'eBf','폜'
  );

const
  Code00 = 'NULSOHSTXETXEOTENQACKBELBS HT LF VT FF CR SO SI ';
  Code01 = 'DLEDC1DC2DC3DC4NAKSYNETBCANEM SUBESCFS GS RS US ';

var
  ExplanationTableE: TExplanationTable;
  ExplanationTableJ: TExplanationTable;

//OZqhL: F^̏ꍇAAȔꍇBԂ
//AAB̏ꍇApɒ
//F̌ʂɊւ炸Aǂ̎]
function SelectLongint(F: Boolean; A,B: Longint): Longint;
begin
  if F then Result := A else Result := B;
end;

//C1C2̓ւ
procedure SwapChar(var C1,C2: Char);
var
  C: Char;
begin
  C := C1;
  C1 := C2;
  C2 := C;
end;

//S̍Et]
procedure ReverseString(var S: string);
var
  L,N: Integer;
begin
  L := Length(S);
  for N := 1 to L div 2 do SwapChar(S[N],S[L-N+1]);
end;

//ϊ ValueRadixi@̕ƂĕԂ
//w肳ꂽ(Digits)菭ȂƂ́A
//ʂ̍̕Ƀ[ߍ܂
function RadixConversionStr(Radix: Integer; Value: Integer; Digits: Integer): string;
const
  C = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
var
  N: Integer;
begin
  Result := '';
  if Length(C) < Radix then Exit; //\łȂ
  //̌ςݏグĂ
  while 0 <> Value do begin
    Result := Result + C[1+(Value mod Radix)];
    Value := Value div Radix;
  end;
  //ЂԂ
  ReverseString(Result);
  //DigitsɂȂ܂œɃ[l߂
  if Length(Result) < Digits then begin
    for N := Digits-Length(Result) downto 1 do begin
      Result := '0' + Result;
    end;
  end;
end;

//Digitsȏ8i\Ԃ
function IntToOct(Value: Integer; Digits: Integer): string;
begin
  Result := RadixConversionStr(8,Value,Digits);
end;

//Digitsȏ2i\Ԃ
function IntToBin(Value: Integer; Digits: Integer): string;
begin
  Result := RadixConversionStr(2,Value,Digits);
end;

//(p)̎擾
function GetExplanationE(N: Byte): string;
begin
  Result := '';
  if N <= High(ExplanationTableE) then begin
    Result := ExplanationTableE[N];
    if '' <> Result then Result := '"' + Result + '"';
  end;
end;

//()̎擾
function GetExplanationJ(N: Byte): string;
begin
  Result := '';
  if N <= High(ExplanationTableJ) then begin
    Result := ExplanationTableJ[N];
    if '' <> Result then Result := '"' + Result + '"';
  end;
end;

//()̎擾
function GetCharacter(N: Byte): string;
begin
  if 127 <= N then Result := ''
  else
  if N <= 31 then begin
    Result := '^'+Chr(N+Ord('@'));
  end else Result := Chr(N);
end;

//j[ACeɕݒ
procedure TASCIICodeMain.SetMenuItemStr(LN,HN: Integer);
var
  N: Integer;
  H,D,O,B,S{,S2},E,J,C,M,M2{,M3}: string;
begin
  with StringGrid1 do begin
    N := HN shl 4 + LN;
    H := IntToHex(N,2);
    D := IntToStr(N);
    O := IntToOct(N,3);
    B := IntToBin(N,8);
    case N of
       0..15: S := Copy(Code00,N*3+1,3);
      16..31: S := Copy(Code01,(N-16)*3+1,3);
          32: S := 'SP ';
         127: S := 'DEL';
    128..255: S := '';
    else
      if VerticalCmd.Checked then S := StringGrid1.Cells[HN+1,LN+1]
                             else S := StringGrid1.Cells[LN+1,HN+1];
    end;
    E := GetExplanationE(N);
    J := GetExplanationJ(N);
    C := GetCharacter(N);
    M2 := '';
    if '' <> E then M2 := M2 + ' ' + E;
    if '' <> J then M2 := M2 + ' ' + J;
    if '' <> C then M2 := M2 + ' ' + C;
    M2 := S + M2;
    M := H + ' ' + D + ' ' + O + ' ' + B + ' ' + M2;
    HexCmd.Caption := '&H) ' + H;
    DecCmd.Caption := '&D) ' + D;
    OctCmd.Caption := '&O) ' + O;
    BinCmd.Caption := '&B) ' + B;
    StrCmd.Caption := '&S) ' + S; StrCmd.Enabled := ('' <> S);
    ExpCmd.Caption := '&E) ' + E; ExpCmd.Enabled := ('' <> E);
    JpnCmd.Caption := '&J) ' + J; JpnCmd.Enabled := ('' <> J);
    ChrCmd.Caption := '&C) ' + C; ChrCmd.Enabled := ('' <> C);
    MixCmd.Caption := '&M) ' + M;
  end;
  ShowStatus(H,D,O,B,M2);
end;

//Xe[^Xo[֕\
procedure TASCIICodeMain.ShowStatus(H,D,O,B,S: string);
begin
  StatusBar1.Panels[0].Text := ' ' + H;
  StatusBar1.Panels[1].Text := D + ' ';
  StatusBar1.Panels[2].Text := ' ' + O;
  StatusBar1.Panels[3].Text := ' ' + B;
  StatusBar1.Panels[4].Text := ' ' + S;
end;

//tH[TCY̒
procedure TASCIICodeMain.AdjustFormSize;
var
  H,W: Integer;
  FH: Integer;
begin
  FH := StatusBar1.Font.Height;
  StatusBar1.Font.Assign(Font);
  StatusBar1.Font.Height := FH;
  StatusBar1.Height := StatusBar1.Canvas.TextHeight('gW') + 8;
  StatusBar1.Panels[0].Width := StatusBar1.Canvas.TextWidth(' WWW ');
  StatusBar1.Panels[1].Width := StatusBar1.Canvas.TextWidth(' WWWW ');
  StatusBar1.Panels[2].Width := StatusBar1.Canvas.TextWidth(' WWWW ');
  StatusBar1.Panels[3].Width := StatusBar1.Canvas.TextWidth(' WWWWWWWW ');
  StringGrid1.LeftCol := 1;
  StringGrid1.TopRow := 1;
  StringGrid1.DefaultRowHeight := Canvas.TextHeight('gW') + 4;//Abs(Font.Height) + 4;
  StringGrid1.DefaultColWidth := {StringGrid1.}Canvas.TextWidth('WWW') + 4;
  //StatusBar1.Height := StringGrid1.DefaultRowHeight + 1;
  W := StringGrid1.DefaultColWidth + StringGrid1.GridLineWidth;
  H := StringGrid1.DefaultRowHeight + StringGrid1.GridLineWidth;
  ClientWidth  := W * StringGrid1.ColCount + 4;
  ClientHeight := H * StringGrid1.RowCount + 4 + StatusBar1.Height;
end;

//Obh̕\
procedure TASCIICodeMain.SetupGrids(bFirstTime: Boolean);
var
  Ini: TIniFile;
  FStyle: TFontStyles;
  FS: Byte absolute FStyle;
  FPitch: TFontPitch;
  FP: Byte absolute FPitch;
  FCharset: TFontCharset;
  FC: Byte absolute FCharset;
  I,J: Integer;
begin
  ImportTables;
  with StringGrid1 do begin
    if VerticalCmd.Checked then begin
      RowCount := 17;
      ColCount := SelectLongint(EightBitsCmd.Checked,17,9);
      for I := 1 to RowCount do Cells[0,I] := '*'+IntToHex(I-1,1);
      for J := 1 to ColCount do Cells[J,0] := IntToHex(J-1,1)+'*';
      if RawCodeCmd.Checked then begin
        for I := 1 to RowCount do Cells[1,I] := ' '+Chr(I-1)+' ';
        for I := 1 to RowCount do Cells[2,I] := ' '+Chr(I-1+$10)+' ';
      end else begin
        for I := 1 to RowCount do Cells[1,I] := Copy(Code00,(I-1)*3+1,3);
        for I := 1 to RowCount do Cells[2,I] := Copy(Code01,(I-1)*3+1,3);
      end;
      for J := 2 to 7 do begin
        for I := 1 to RowCount do Cells[J+1,I] := Chr($10*J+I-1);
      end;
      if RawCodeCmd.Checked then begin
        Cells[3,1] := #32;
        Cells[8,16] := #127;
      end else begin
        Cells[3,1] := 'SP ';
        Cells[8,16] := 'DEL';
      end;
      if EightBitsCmd.Checked then begin
        for J := 8 to 15 do begin
          for I := 1 to RowCount do Cells[J+1,I] := ' '+Chr($10*J+I-1)+' ';
        end;
      end;
    end else begin
      ColCount := 17;
      RowCount := SelectLongint(EightBitsCmd.Checked,17,9);
      for I := 1 to ColCount do Cells[I,0] := '*'+IntToHex(I-1,1);
      for J := 1 to RowCount do Cells[0,J] := IntToHex(J-1,1)+'*';
      if RawCodeCmd.Checked then begin
        for I := 1 to ColCount do Cells[I,1] := ' '+Chr(I-1)+' ';
        for I := 1 to ColCount do Cells[I,2] := ' '+Chr(I-1+$10)+' ';
      end else begin
        for I := 1 to ColCount do Cells[I,1] := Copy(Code00,(I-1)*3+1,3);
        for I := 1 to ColCount do Cells[I,2] := Copy(Code01,(I-1)*3+1,3);
      end;
      for J := 2 to 7 do begin
        for I := 1 to ColCount do Cells[I,J+1] := Chr($10*J+I-1);
      end;
      if RawCodeCmd.Checked then begin
        Cells[1,3] := #32;
        Cells[16,8] := #127;
      end else begin
        Cells[1,3] := 'SP ';
        Cells[16,8] := 'DEL';
      end;
      if EightBitsCmd.Checked then begin
        for J := 8 to 15 do begin
          for I := 1 to ColCount do Cells[I,J+1] := ' '+Chr($10*J+I-1)+' ';
        end;
      end;
    end;
  end;
  if bFirstTime then begin
    SetMenuItemStr(0,0);
    Ini := TIniFile.Create(ChangeFileExt(ParamStr(0),'.INI'));
    try
      Left   := Ini.ReadInteger('MainWindow','Left',0);
      Top    := Ini.ReadInteger('MainWindow','Top',0);
      //Width  := Ini.ReadInteger('MainWindow','Width',Width);
      //Height := Ini.ReadInteger('MainWindow','Height',Height);
      Font.Name := Ini.ReadString('Font','Name','lr oSVbN');
      FC := Ini.ReadInteger('Font','Charset',SHIFTJIS_CHARSET);
      Font.Color := StringToColor(Ini.ReadString ('Font','Color','clWindowText'));
      Font.Height := Ini.ReadInteger('Font','Height',-12);
      FP := Ini.ReadInteger('Font','Pitch',Ord(fpDefault));
      FS := Ini.ReadInteger('Font','Style',0);
      Font.Charset := FCharset;
      Font.Pitch := FPitch;
      Font.Style := FStyle;
      //StringGrid1.DefaultRowHeight := Ini.ReadInteger('Cell','Height',StringGrid1.DefaultRowHeight);
      //StringGrid1.DefaultColWidth := Ini.ReadInteger('Cell','Width',StringGrid1.DefaultColWidth);
      StringGrid1.Color := StringToColor(Ini.ReadString ('MainWindow','Color','clWindow'));
      StringGrid1.FixedColor := StringToColor(Ini.ReadString ('MainWindow','FixedColor','clBtnFace'));
    finally
      Ini.Free;
    end;
  end;
  AdjustFormSize;
end;

procedure TASCIICodeMain.FormCreate(Sender: TObject);
var
  Ini: TIniFile;
begin
  Application.Title := Caption;
  Ini := TIniFile.Create(ChangeFileExt(ParamStr(0),'.INI'));
  try
    VerticalCmd.Checked := Ini.ReadBool('MainWindow','Vertical',False);
    EightBitsCmd.Checked := Ini.ReadBool('MainWindow','8bits',False);
    RawCodeCmd.Checked := Ini.ReadBool('MainWindow','RawCode',False);
  finally
    Ini.Free;
  end;
end;

procedure TASCIICodeMain.StringGrid1SelectCell(Sender: TObject; Col, Row: Integer;
  var CanSelect: Boolean);
begin
  if VerticalCmd.Checked then SetMenuItemStr(Row-1,Col-1)
                         else SetMenuItemStr(Col-1,Row-1);
end;

procedure TASCIICodeMain.FormShow(Sender: TObject);
begin
  SetupGrids(True);
end;

procedure TASCIICodeMain.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  Ini: TIniFile;
  FStyle: TFontStyles;
  FS: Byte absolute FStyle;
  FPitch: TFontPitch;
  FP: Byte absolute FPitch;
  FCharset: TFontCharset;
  FC: Byte absolute FCharset;
begin
  FStyle := Font.Style;
  FPitch := Font.Pitch;
  FCharset := Font.Charset;
  Ini := TIniFile.Create(ChangeFileExt(ParamStr(0),'.INI'));
  try
    Ini.WriteInteger('MainWindow','Left',Left);
    Ini.WriteInteger('MainWindow','Top',Top);
    //Ini.WriteInteger('MainWindow','Width',Width);
    //Ini.WriteInteger('MainWindow','Height',Height);
    Ini.WriteInteger('Font','Charset',FC);
    Ini.WriteString ('Font','Color',ColorToString(Font.Color));
    Ini.WriteInteger('Font','Height',Font.Height);
    Ini.WriteString ('Font','Name',Font.Name);
    Ini.WriteInteger('Font','Pitch',FP);
    Ini.WriteInteger('Font','Style',FS);
    //Ini.WriteInteger('Cell','Height',StringGrid1.DefaultRowHeight);
    //Ini.WriteInteger('Cell','Width',StringGrid1.DefaultColWidth);
    Ini.WriteBool('MainWindow','Vertical',VerticalCmd.Checked);
    Ini.WriteBool('MainWindow','8bits',EightBitsCmd.Checked);
    Ini.WriteString ('MainWindow','Color',ColorToString(StringGrid1.Color));
    Ini.WriteString ('MainWindow','FixedColor',ColorToString(StringGrid1.FixedColor));
    Ini.WriteBool('MainWindow','RawCode',RawCodeCmd.Checked);
  finally
    Ini.Free;
  end;
end;

procedure TASCIICodeMain.MenuItem1Click(Sender: TObject);
var
  N: Integer;
  S: string;
begin
  if Sender is TMenuItem then begin
    S := (Sender as TMenuItem).Caption;
    if '&' <> S[1] then N := 1 else N := 5;
    ClipBoard.AsText := Copy(S,N,MaxInt)
  end;
end;

procedure TASCIICodeMain.FontCmdClick(Sender: TObject);
var
  KeepFont: TFont;
begin
  KeepFont := TFont.Create;
  try
    KeepFont.Assign(Font);
    FontDialog1.Font.Assign(Font);
    if FontDialog1.Execute then Font.Assign(FontDialog1.Font)
                           else Font.Assign(KeepFont);
  finally
    KeepFont.Free;
  end;
  AdjustFormSize;
end;

procedure TASCIICodeMain.FontDialog1Apply(Sender: TObject; Wnd: HWND);
begin
  Font.Assign(FontDialog1.Font);
  AdjustFormSize;
end;

procedure TASCIICodeMain.StringGrid1DrawCell(Sender: TObject; Col,
  Row: Integer; Rect: TRect; State: TGridDrawState);
begin
  //Z̃Z^O
  StringGrid1.Canvas.FillRect(Rect);
  Rect.Top := Rect.Top + 2;
  DrawText(StringGrid1.Canvas.Handle,PChar(StringGrid1.Cells[Col,Row]),
    Length(StringGrid1.Cells[Col,Row]),Rect,DT_CENTER);
end;

procedure TASCIICodeMain.GenerateCmdClick(Sender: TObject);
begin
  ExportTables;
end;

procedure ExportTable(FN: string; Src: TExplanationTable);
var
  FS: TFileStream;
  N: Integer;
begin
  FN := ExtractFilePath(ParamStr(0)) + FN;
  FS := TFileStream.Create(FN,fmCreate or fmShareDenyWrite);
  try
    for N := 0 to High(Src) do begin
      FS.Write(Src[N][1],Length(Src[N]));
      FS.Write(^M^J,2);
    end;
  finally
    FS.Free;
  end;
end;

procedure TASCIICodeMain.ExportTables;
begin
  ExportTable('ExplainJ.txt',ExplanationTableJDefault);
  ExportTable('ExplainE.txt',ExplanationTableEDefault);
end;

procedure CopyExplanationTable(var Dest,Source: TExplanationTable);
var
  N: Integer;
begin
  for N := 0 to High(Dest) do Dest[N] := Source[N];
end;

procedure CopyExplanationTable2(var Dest: TExplanationTable; Source: TStrings);
var
  N: Integer;
begin
  for N := 0 to High(Dest) do Dest[N] := Source[N];
end;

procedure ImportTable(FN: string; var Dst,Def: TExplanationTable);
var
  SL: TStringList;
  FS: TFileStream;
begin
  FN := ExtractFilePath(ParamStr(0)) + FN;
  try
    SL := TStringList.Create;
    try
      FS := TFileStream.Create(FN,fmOpenRead or fmShareDenyWrite);
      try
        SL.LoadFromStream(FS);
      finally
        FS.Free;
      end;
      if TableLines <= SL.Count then CopyExplanationTable2(Dst,SL)
                                else CopyExplanationTable(Dst,Def);
    finally
      SL.Free;
    end;
  except
    CopyExplanationTable(Dst,Def);
  end;
end;

procedure TASCIICodeMain.ImportTables;
begin
  ImportTable('ExplainJ.txt',ExplanationTableJ,ExplanationTableJDefault);
  ImportTable('ExplainE.txt',ExplanationTableE,ExplanationTableEDefault);
end;

procedure TASCIICodeMain.ExitCmdClick(Sender: TObject);
begin
  Close;
end;

procedure TASCIICodeMain.StringGrid1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  C,R: Longint;
begin
  //ENbNɂI
  if Button = mbRight then begin
    StringGrid1.MouseToCell(X,Y,C,R);
    if (0 < C) and (0 < R) then begin
      StringGrid1.Col := C;
      StringGrid1.Row := R;
    end;
  end;
end;

procedure TASCIICodeMain.StringGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);

  function IsTopEnd(Grid: TStringGrid): Boolean;
  begin
    Result := (Grid.Row <= Grid.FixedRows);
  end;

  function IsBottomEnd(Grid: TStringGrid): Boolean;
  begin
    Result := (Grid.RowCount-1 <= Grid.Row);
  end;

  function IsLeftEnd(Grid: TStringGrid): Boolean;
  begin
    Result := (Grid.Col <= Grid.FixedCols);
  end;

  function IsRightEnd(Grid: TStringGrid): Boolean;
  begin
    Result := (Grid.ColCount-1 <= Grid.Col);
  end;

begin
  case Key of
    VK_F10:
    begin
      if Shift = [ssShift] then begin
        Key := 0;
        with StringGrid1.ClientToScreen(Point(0,0)) do PopupMenu1.Popup(X,Y);
      end;
    end;
    VK_UP:
    begin
      if VerticalCmd.Checked and (Shift = []) then with StringGrid1 do begin
        if IsTopEnd(StringGrid1) then begin
          Key := 0;
          Col := SelectLongint(IsLeftEnd(StringGrid1),ColCount-1,Col-1);
          Row := RowCount-1;
        end;
      end;
    end;
    VK_DOWN:
    begin
      if VerticalCmd.Checked and (Shift = []) then with StringGrid1 do begin
        if IsBottomEnd(StringGrid1) then begin
          Key := 0;
          Col := SelectLongint(IsRightEnd(StringGrid1),FixedCols,Col+1);
          Row := FixedRows;
        end;
      end;
    end;
    VK_LEFT:
    begin
      if (not VerticalCmd.Checked) and (Shift = []) then with StringGrid1 do begin
        if IsLeftEnd(StringGrid1) then begin
          Key := 0;
          Row := SelectLongint(IsTopEnd(StringGrid1),RowCount-1,Row-1);
          Col := ColCount-1;
        end;
      end;
    end;
    VK_RIGHT:
    begin
      if (not VerticalCmd.Checked) and (Shift = []) then with StringGrid1 do begin
        if IsRightEnd(StringGrid1) then begin
          Key := 0;
          Row := SelectLongint(IsBottomEnd(StringGrid1),FixedRows,Row+1);
          Col := FixedCols;
        end;
      end;
    end;
  end;
end;

procedure TASCIICodeMain.VerticalCmdClick(Sender: TObject);
begin
  VerticalCmd.Checked := not VerticalCmd.Checked;
  SetupGrids(False);
end;

procedure TASCIICodeMain.EightBitsCmdClick(Sender: TObject);
begin
  EightBitsCmd.Checked := not EightBitsCmd.Checked;
  SetupGrids(False);
end;

procedure ReadCustomColors(CustomColors: TStrings);
var
  Ini: TIniFile;
  K,S: string;
  N: Integer;
begin
  Ini := TIniFile.Create(ChangeFileExt(ParamStr(0),'.INI'));
  try
    CustomColors.Clear;
    for N := Ord('A') to Ord('P') do begin
      K := 'Color'+Chr(N);
      S := Ini.ReadString('CustomColors',K,'FFFFFF');
      CustomColors.Add(K + '=' + S);
    end;
  finally
    Ini.Free;
  end;
end;

procedure WriteCustomColors(CustomColors: TStrings);
var
  Ini: TIniFile;
  K,S: string;
  N: Integer;
  nPos: Integer;
begin
  Ini := TIniFile.Create(ChangeFileExt(ParamStr(0),'.INI'));
  try
    for N := 0 to CustomColors.Count-1 do begin
      S := CustomColors[N];
      nPos := Pos('=',S);
      if 1 < nPos then begin
        K := Copy(S,1,nPos-1);
        S := Copy(S,nPos+1,MaxInt);
        Ini.WriteString('CustomColors',K,S);
      end;
    end;
  finally
    Ini.Free;
  end;
end;

procedure TASCIICodeMain.ColorCmdClick(Sender: TObject);
begin
  ReadCustomColors(ColorDialog1.CustomColors);
  ColorDialog1.Color := StringGrid1.Color;
  if ColorDialog1.Execute then begin
    StringGrid1.Color := ColorDialog1.Color;
    WriteCustomColors(ColorDialog1.CustomColors);
  end;
end;

procedure TASCIICodeMain.FixedColorCmdClick(Sender: TObject);
begin
  ReadCustomColors(ColorDialog1.CustomColors);
  ColorDialog1.Color := StringGrid1.FixedColor;
  if ColorDialog1.Execute then begin
    StringGrid1.FixedColor := ColorDialog1.Color;
    WriteCustomColors(ColorDialog1.CustomColors);
  end;
end;

procedure TASCIICodeMain.RawCodeCmdClick(Sender: TObject);
begin
  RawCodeCmd.Checked := not RawCodeCmd.Checked;
  SetupGrids(False);
end;

end.
