/* du.cpp
*/
/*
 * du - copyright (C) 1996,1997 y.ohm
 *
 *  fBNg̎gp󋵂\B
 *  ϐDU(R}h'.EXE'͂)ɃftHgIvV
 *  ݒł̂ŁASET DU=-pƂłĂ ASCII SOFTWARE TOOLS
 *  duƓgSn͂B
 *  Ȃ݂ɍ҂́ASET DU=-bCghnpstƂĂBdu -?ŃwvoB
 *  K.TeradadirsizeTOOLSdu̎dl悤Ȃ̂ɂȂ
 *  BɎw肷̂̓fBNgłāAt@Cł͂ȂB
 *
 * v1.10 Feb 8, 1997:
 *  LongFileNameł̕\~̂ŁA Win32R\[pɂRp
 *  Cł悤ɂBƂ͂ĂA_dos_n̊֐gĂ̂
 *  BorlandƎ̂̂ɒuB
 * v1.00 Jun 2, 1996:
 *  (DOS)
 */
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <ctype.h>
#include <jctype.h>
#include <string.h>
#include <signal.h>
#include <math.h>
#ifdef _Windows
#include <windows.h>
#endif

#define VERSTR "1.10"
#define FA_ANY (FA_HIDDEN|FA_SYSTEM|FA_DIREC)

int flip(int&x) { return x = !x; }
void putnchar(int c,int n){ for (int i = 0; i < n; i++) putchar(c); }
char**av;

const char*cmdname()
{
	static char name[MAXFILE];
	if (!*name){
		fnsplit(av[0],NULL,NULL,name,NULL);
		strupr(name);
	}
	return name;
}

int Usage()
{
	printf("%s v%s\n",cmdname(),VERSTR);
	printf("  Usage: %s [-bCfghnpst] [-c[#.@<drive><size>]] [<pathname>]\n",cmdname());
	printf("  Options:\n");
	printf("    -b    oCgPʂł̕\ǉ\n");
	printf("    -C    lJ}ҏWĕ\\n");
	printf("    -f    t@C܂߂ĕ\\n");
	printf("    -g    NX^MbvTCY̕\\n");
	printf("    -h    ot\n");
	printf("    -n    t@C̕\\n");
	printf("    -p    <pathname>ɈړĂ\\n");
	printf("    -s    NX^~NX^TCY̕\\n");
	printf("    -t    ЂƂ̃fBNg܂ł\\n");
	printf("    -c    \ɗpNX^TCY̎w\n");
	printf("          -c#     \hCũNX^TCY\n");		// default
	printf("          -c.     JghCũNX^TCY\n");
	printf("          -c@     JghCũNX^TCY\n");
	printf("          -ca     AhCũNX^TCY\n");
	printf("          -c8192  NX^TCY8192oCg\n");
	printf("          -c0     oCgPʂŕ\\n");
	printf("          -c      oCgPʂŕ\\n");
	printf("    -k    -c1024Ɠ\n");
	return 1;
}

struct TOpt{
	unsigned drive;
	char*pathname;
	int use_c;
	unsigned long c;
	int f,t,b,C,n,p,g,s,h;
	char startpath[MAXPATH];
	TOpt();
	~TOpt();
} opt;

TOpt::TOpt()
{
	drive = getdisk();
	drive += 'A';
	pathname = ".";
	use_c = 0;
	c = 0;		// \ɗpNX^TCY
	f = 0;		// t@C܂߂ĕ\
	t = 0;		// ЂƂ̃fBNg܂ł\
	s = 0;		// NX^~NX^TCY̕\
	C = 0;		// lJ}ҏWĕ\
	n = 0;		// t@C̕\
	p = 0;		// pathnameɈړĂ\
	g = 0;		// NX^Mbv̕\
	b = 0;		// oCgPʂł̕\ǉ
	h = 0;		// ot
	if (!getcwd(startpath,MAXPATH))	*startpath = '\0';
}

TOpt::~TOpt()
{
	if (*startpath){
		/*int ndrives = */setdisk(toupper(*startpath) - 'A');
		chdir(startpath);
	}
}

double ratio(double a,double b)
{
	double ratio = 0;
	if (b)	ratio = a * 100 / b;
	return ratio;
}

// dJ}ҏWpɓ
// pԂ
// ndig: _ȉ̌
char*commastr(char*p,double d,int ndig)
{
	int sign = 0;
	if (d < 0)	sign = 1;
	d = fabs(d);
	int len = sprintf(p,"%.*f",ndig,d);
	char*q = new char[len+1];
	if (q){
		strcpy(q,p);
		strrev(q);
		int i,j,c;
		for (i = j = c = 0; i < len; i++){
			if (!strchr(q+i,'.')){
				if (3 < ++c){
					c = 1;
					p[j++] = ',';
				}
			}
			p[j++] = q[i];
		}
		p[j] = '\0';
		delete[]q;
		if (sign)	strcat(p,"-");
		strrev(p);
	}
	return p;
}

char*comma(unsigned long n,int width)
{
	static char s[14];	// (10-1)/3+10+1
	if (opt.C){
		width += (width - 1) / 3;	// J}̕g
		char w[14];
		sprintf(s,"%*s",width,commastr(w,n,0));
	}else	sprintf(s,"%*lu",width,n);
	return s;
}

struct files_t{
	unsigned files;
	unsigned long size;
	unsigned long clusts;
	files_t(unsigned f=0, unsigned long s=0, unsigned long c=0)
	{
		files = f; size = s; clusts = c;
	}
	files_t& operator+=(files_t&a);
	friend files_t operator+(files_t&a,files_t&b);
};

files_t& files_t::operator+=(files_t&a)
{
	files  += a.files;
	size   += a.size;
	clusts += a.clusts;
	return *this;
}

files_t operator+(files_t&a,files_t&b)
{
	files_t ret;
	ret.files   = a.files  + b.files;
	ret.size    = a.size   + b.size;
	ret.clusts  = a.clusts + b.clusts;
	return ret;
}

void header()
{
	printf((4295 <= opt.c) ? (opt.C?"%7s":"%6s") : (opt.C?"%13s":"%10s"),"clusts");
	if (opt.s && opt.c)	printf(opt.C?" %13s":" %10s","amounts");
	if (opt.b)			printf(opt.C?" %13s":" %10s","bytes");
	if (opt.g && opt.c)	printf(opt.C?" %13s":" %10s","gap");
	if (opt.n)			printf(opt.C?" %7s" :" %6s", "files");
	printf("\n");
}

void headerLine()
{
	putnchar('-',(4295 <= opt.c) ? (opt.C ?  7 :  6) : (opt.C ? 13 : 10));
	if (opt.s && opt.c)	{ putchar(' '); putnchar('-',opt.C ? 13 : 10); }
	if (opt.b)			{ putchar(' '); putnchar('-',opt.C ? 13 : 10); }
	if (opt.g && opt.c)	{ putchar(' '); putnchar('-',opt.C ? 13 : 10); }
	if (opt.n)			{ putchar(' '); putnchar('-',opt.C ?  7 :  6); }
	printf("\n");
}

// ̍ŌオSBCS̏ꍇA̕Ԃ
// ȊȌꍇA0
int GetLastChar(const char*s)
{
	int ret = 0;
	int len = strlen(s);
	for (int i = 0; i < len; i++){
		if (iskanji(s[i]))	i++;
		else
		if (len - 1 <= i)	ret = s[i];
	}
	return ret;
}

files_t DirTree(const char*pathname,unsigned long clsiz,int depth=-1)
{
	if (depth < 0){
		char path[MAXPATH];
		strcpy(path,pathname);
		int ch = GetLastChar(path);
		if (':'!=ch && '\\'!=ch && '/'!=ch)	strcat(path,"\\");
		return DirTree(path,clsiz,0);
	}
	files_t files;
	char*path = new char[MAXPATH];
	sprintf(path,"%s*.*",pathname);
	ffblk ff;
	int ffRet = findfirst(path,&ff,FA_ANY);
	while (!ffRet){
		if (strcmp(".", ff.ff_name) && strcmp("..",ff.ff_name)){
			if (FA_DIREC & ff.ff_attrib){
				sprintf(path,"%s%s\\",pathname,ff.ff_name);
				files_t aFiles = DirTree(path,clsiz,depth+1);
				if (!opt.t || !depth){
					printf("%s",comma(aFiles.clusts,(4295 <= clsiz) ? 6 : 10));
					if (opt.s && clsiz){
						printf(" %s",comma(aFiles.clusts * clsiz,10));
					}
					if (opt.b)	printf(" %s",comma(aFiles.size,10));
					if (opt.g && clsiz){
						printf(" %s",comma(clsiz * aFiles.clusts - aFiles.size,10));
					}
					if (opt.n)	printf(" %s",comma(aFiles.files,6));
					printf("   %s%s%s\n",pathname,ff.ff_name,opt.f?"\\":"");
				}
				files += aFiles;
			}else
			if (!(FA_LABEL & ff.ff_attrib)){ // t@C
				long cl = ff.ff_fsize;
				if (ff.ff_fsize && clsiz){
					cl = ff.ff_fsize / clsiz;
					if (ff.ff_fsize % clsiz)	cl++;
				}
				files += files_t(1,ff.ff_fsize,cl);
				if (opt.f){
					if (!opt.t || !depth){
						printf("%s",comma(cl,(4295 <= clsiz) ? 6 : 10));
						if (opt.s && clsiz){
							printf(" %s",comma(cl * clsiz,10));
						}
						if (opt.b)	printf(" %s",comma(ff.ff_fsize,10));
						if (opt.g && clsiz){
							printf(" %s",comma(clsiz * cl - ff.ff_fsize,10));
						}
						if (opt.n)	printf(" %s",comma(1,6));
						printf("   %s%s\n",pathname,ff.ff_name);
					}
				}
			}
		}
		ffRet = findnext(&ff);
	}
	delete[]path;
	return files;
}

// '@':current,'A':A: drive,...
long GetClusterSize(unsigned int drive)
{
	long ret = 0;
	dfree df;
    unsigned int d = toupper(drive) - '@';
	getdfree((unsigned char)d,&df);
	if (df.df_sclus != (unsigned)-1)	ret = (long)df.df_bsec * df.df_sclus;
	return ret;
}

int ParseArg(char*arg)
{
	if ('/' == *arg || '-' == *arg){
		while (*++arg){
			switch (*arg){
			case 'k':
				opt.use_c = 1;
				opt.c = 1024;
				break;
			case 'c':
				if ('.' == arg[1])	arg[1] = '@';
				if ('#' == arg[1]){
					opt.use_c = 0;
					arg++;
				}else
				if ('@' == arg[1] || isalpha(arg[1])){
					opt.use_c = 1;
					opt.c = GetClusterSize(arg[1]);
					arg++;
				}else{
					opt.use_c = 1;
					opt.c = strtoul(arg+1,&arg,0);
					arg--;
				}
				break;
			case 'b':	flip(opt.b);	break;
			case 'g':	flip(opt.g);	break;
			case 'f':	flip(opt.f);	break;
			case 't':	flip(opt.t);	break;
			case 'C':	flip(opt.C);	break;
			case 'n':	flip(opt.n);	break;
			case 'p':	flip(opt.p);	break;
			case 's':	flip(opt.s);	break;
			case 'h':	flip(opt.h);	break;
			case '?':
				return Usage();
			}
		}
	}else{
		opt.pathname = arg;
		if (':' == arg[1] && isalpha(arg[0])){
			opt.drive = toupper(arg[0]);
		}
	}
	if ((opt.s || opt.g) && opt.use_c && !opt.c)	opt.use_c = 0;
	return 0;
}

#ifndef _Windows
void int23h_handler(int)
{
	fprintf(stderr,"\aInterrupted!!\n");
	exit(1);
}

void far int24h_handler(unsigned,unsigned,unsigned far*)
{
	_hardresume(_HARDERR_FAIL);
}
#endif

int main(int argc,char**argv)
{
	av = argv;
#ifndef _Windows
	signal(SIGINT,int23h_handler);
	_harderr(int24h_handler);
#endif
	char*envarg = getenv(cmdname());
	if (envarg)	if (ParseArg(envarg))	return 1;
	for (int i = 1; i < argc; i++)	if (ParseArg(argv[i]))	return 1;
	if (opt.p){
		if (':' == opt.pathname[1] && isalpha(opt.pathname[0])){
			/*int ndrives = */setdisk(toupper(opt.pathname[0]) - 'A');
			opt.drive = getdisk();
			opt.drive += 'A';
		}
		chdir(opt.pathname);
		opt.pathname = ".";
	}
	dfree df;
	unsigned int d = opt.drive - '@';
	getdfree((unsigned char)d,&df);
	if (df.df_sclus != (unsigned)-1){
		unsigned df_bytes_per_cluster = df.df_sclus * df.df_bsec;
//		unsigned df_used_clusters     = df.df_total - df.df_avail;
		if (!opt.use_c){
			opt.use_c = 1;
			opt.c = df_bytes_per_cluster;
		}
		if (opt.c)	printf("%ld bytes per cluster\n",opt.c);
		if (opt.h)	{ header(); headerLine(); }
		files_t files = DirTree(opt.pathname,opt.c);
		printf("%s",comma(files.clusts,(4295 <= opt.c) ? 6 : 10));
		if (opt.s && opt.c)	printf(" %s",comma(files.clusts * opt.c,10));
		if (opt.b)	printf(" %s",comma(files.size,10));
		if (opt.g && opt.c){
			printf(" %s",comma(opt.c * files.clusts - files.size,10));
		}
		if (opt.n)	printf(" %s",comma(files.files,6));
		printf("   %s\n",opt.pathname);
		unsigned long clfree_bytes = (unsigned long)df.df_avail * df_bytes_per_cluster;
		unsigned long clfree = clfree_bytes;
		if (opt.c)	clfree /= opt.c;
		printf("%s",comma(clfree,(4295 <= opt.c) ? 6 : 10));
		if (opt.s && opt.c)	printf(" %s",comma(clfree * opt.c,10));
		if (opt.b)	printf(" %s",comma(clfree_bytes,10));
		if (opt.g && opt.c)	printf(opt.C ? " %13s":" %10s","");
		if (opt.n)	printf(opt.C ? " %7s":" %6s","");
		printf("   free\n");
#if 0
		printf("\n");
		printf("total_clusters:      %-6u (%10lu bytes)\n",df.total_clusters,(unsigned long)df.total_clusters*df_bytes_per_cluster);
		printf("avail_clusters:      %-6u (%10lu bytes) - %6.2f%%\n",df.avail_clusters,(unsigned long)df.avail_clusters*df_bytes_per_cluster,ratio(df.avail_clusters,df.total_clusters));
		printf("used_clusters:       %-6u (%10lu bytes) - %6.2f%%\n",df_used_clusters, (unsigned long)df_used_clusters*df_bytes_per_cluster, ratio(df_used_clusters, df.total_clusters));
		printf("sectors_per_cluster: %u\n",df.sectors_per_cluster);
		printf("bytes_per_sector:    %u\n",df.bytes_per_sector);
		printf("bytes_per_cluster:   %u\n",df_bytes_per_cluster);
#endif
	}
	return 0;
}

