unit EjMedia;

interface

uses
  Windows;

function EjectMediaInDrive(nDrive: Byte): Boolean;

implementation

const
  VWIN32_DIOC_DOS_IOCTL = 1;

type
  PDEVIOCTL_REGISTERS = ^TDEVIOCTL_REGISTERS;
  TDEVIOCTL_REGISTERS = packed record
    reg_EBX: DWord;
    reg_EDX: DWord;
    reg_ECX: DWord;
    reg_EAX: DWord;
    reg_EDI: DWord;
    reg_ESI: DWord;
    reg_Flags: DWord;
  end;

function DoIOCTL(var Reg: TDEVIOCTL_REGISTERS): Boolean;
var
  hDevice: THandle;
  fResult: Boolean;
  cb: DWord;
begin
  Result := False;
  Reg.reg_Flags := $8000; // assume error (carry flag set)
  hDevice := CreateFile(
    '\\.\vwin32',
    GENERIC_READ,
    FILE_SHARE_READ or FILE_SHARE_WRITE,
    PSecurityAttributes(nil),
    OPEN_EXISTING,
    FILE_ATTRIBUTE_NORMAL,
    THandle(nil)
  );
  if hDevice <> THandle(INVALID_HANDLE_VALUE) then begin
    fResult := DeviceIoControl(
      hDevice, VWIN32_DIOC_DOS_IOCTL,
      @Reg, SizeOf(Reg), @Reg, SizeOf(Reg), cb, nil
    );
    if fResult then begin
      CloseHandle(hDevice);
      Result := True;
    end;
  end;
end;

{ Eject media in drive(GENERIC BLOCK DEVICE REQUEST) }
{ nDrive: drive number (00h=default,01h=A:,etc) }
function EjectMediaInDrive(nDrive: Byte): Boolean;
var
  Reg: TDEVIOCTL_REGISTERS;
begin
  Result := False;
(*
 * From Ralf Brown's Interrupt List Release 53
 *
 * INT 21 440D - DOS 3.2+ - IOCTL - GENERIC BLOCK DEVICE REQUEST
 *   AX = 440Dh
 *   BL = drive number (00h=default,01h=A:,etc)
 *   CH = category code (08h:disk drive, 48h:FAT32 disk drive, ...)
 *   CL = minor code (function) (..., 49h:(Enh. Disk Drive Spec) eject media in drive (see INT 13/AH=49h), ...)
 *   DS:DX -> (DOS) parameter block
 *   SI:DI -> (OS/2 comp box) parameter block
 * Return: CF set on error
 *     AX = error code (01h,02h,etc.)
 *     CF clear if successful
 *	 DS:DX -> data block if CL=60h or CL=61h
 *)
  with Reg do begin
    reg_EAX := $440D;       // IOCTL for block devices
    reg_EBX := nDrive;      // zero-based drive ID
    reg_ECX := $0849;       // eject media in drive ($4849 for FAT32 disk drive?)
    reg_EDX := 0;           // no parameter block required
  end;
  if DoIOCTL(Reg) then begin
    // error if carry flag set
    if 0 = (Reg.reg_Flags and $8000) then Result := True;
    // Result := ($FFFF & Reg.reg_EAX);
  end;
end;

end.
