#include <windows.h>
#pragma hdrstop
#include <stdlib.h>
#include <stdio.h>
#include <mbstring.h>
#include <string.h>
#include <winver.h>
#include <dos.h>
#include <dir.h>

void*   lpData;			// o[W\[X̃obt@
LPVOID  lpBuffer;		// o[Wl̃obt@
UINT    wSize;			// o[Wl̃obt@TCY
LPDWORD lpdwID;
char    cStartBuf[64];

int OptJ = 0;			// Japanese
int OptF = 0;			// Fixed File Info
int OptV = 0;			// Verbose
int OptQ = 0;			// Quiet

int StringFileInfo(char*name, BOOL disp=TRUE);

void Usage()
{
	printf("iVer 1.2p Usage:\n");
	printf("iVer [-jfvq] <Files>...\n");
	printf("-j : Japanese\n");
	printf("-f : Fixed file info\n");
	printf("-v : Verbose\n");
	printf("-q : Quiet\n");
}

void RootFileInfo()
{
	char WorkStr[128];
	VS_FIXEDFILEINFO *ffiData;
	if (VerQueryValue(lpData, "\\", (void**)&ffiData, &wSize)){
		if (OptJ)	wsprintf(WorkStr, "%22s", "io[W");
		else		wsprintf(WorkStr, "%16s", "ProductVersion");
		printf("%s: %u.%u.%u.%u\n", WorkStr,
			HIWORD(ffiData->dwProductVersionMS),
			LOWORD(ffiData->dwProductVersionMS),
			HIWORD(ffiData->dwProductVersionLS),
			LOWORD(ffiData->dwProductVersionLS)
		 );
		if (OptJ)	wsprintf(WorkStr, "%22s", "t@Co[W");
		else		wsprintf(WorkStr, "%16s", "FileVersion");
		printf("%s: %u.%u.%u.%u\n", WorkStr,
			HIWORD(ffiData->dwFileVersionMS),
			LOWORD(ffiData->dwFileVersionMS),
			HIWORD(ffiData->dwFileVersionLS),
			LOWORD(ffiData->dwFileVersionLS)
		 );
		if (OptJ)	wsprintf(WorkStr, "%22s: ", "ΏOS");
		else		wsprintf(WorkStr, "%16s: ", "FileOS");
		switch(ffiData->dwFileOS){
		 case VOS_DOS:				strcat(WorkStr,"MS-DOS");							break;
		 case VOS_OS216:			strcat(WorkStr,"16bit OS/2");						break;
		 case VOS_OS232:			strcat(WorkStr,"32bit OS/2");						break;
		 case VOS_NT:				strcat(WorkStr,"Windows NT");						break;
		 case VOS__WINDOWS16:		strcat(WorkStr,"16bit Windows");					break;
		 case VOS__PM16:			strcat(WorkStr,"16bit PM");							break;
		 case VOS__PM32:			strcat(WorkStr,"32bit PM");							break;
		 case VOS__WINDOWS32:		strcat(WorkStr,"32bit Windows");					break;
		 case VOS_DOS_WINDOWS16:	strcat(WorkStr,"16bit Windows on MS-DOS");			break;
		 case VOS_DOS_WINDOWS32:	strcat(WorkStr,"32bit Windows on MS-DOS");			break;
		 case VOS_OS216_PM16:		strcat(WorkStr,"16bit PM on 16bit OS/2");			break;
		 case VOS_OS232_PM32:		strcat(WorkStr,"32bit PM on 32bit OS/2");			break;
		 case VOS_NT_WINDOWS32:		strcat(WorkStr,"32bit Windows on Windows NT");		break;
		 case VOS_UNKNOWN:
		 default:					strcat(WorkStr,OptJ?"s":"Unknown");				break;
		}
		printf("%s\n",WorkStr);
		if (OptJ)	wsprintf(WorkStr, "%22s: ", "t@C^Cv");
		else		wsprintf(WorkStr, "%16s: ", "FileType");
		switch(ffiData->dwFileType){
		 case VFT_APP:
			strcat(WorkStr,OptJ?"AvP[V":"Application");
			break;
		 case VFT_DLL:
			strcat(WorkStr,OptJ?"_Ci~bNNCu":"Dynamic Link Library");
			break;
		 case VFT_DRV:
			strcat(WorkStr,OptJ?"foCXhCo":"Device Driver");
			switch(ffiData->dwFileSubtype){
			 case VFT2_DRV_PRINTER:		strcat(WorkStr,OptJ?"(v^)":"(Printer)");				break;
			 case VFT2_DRV_KEYBOARD:	strcat(WorkStr,OptJ?"(L[{[h)":"(Keyboard)");			break;
			 case VFT2_DRV_LANGUAGE:	strcat(WorkStr,OptJ?"()":"(Language)");					break;
			 case VFT2_DRV_DISPLAY:		strcat(WorkStr,OptJ?"(fBXvC)":"(Display)");			break;
			 case VFT2_DRV_MOUSE:		strcat(WorkStr,OptJ?"(}EX)":"(Mouse)");					break;
			 case VFT2_DRV_NETWORK:		strcat(WorkStr,OptJ?"(lbg[N)":"(Network)");			break;
			 case VFT2_DRV_SYSTEM:		strcat(WorkStr,OptJ?"(VXe)":"(System)");				break;
			 case VFT2_DRV_INSTALLABLE:	strcat(WorkStr,OptJ?"(CXg[\)":"(Installable)");	break;
			 case VFT2_DRV_SOUND:		strcat(WorkStr,OptJ?"(TEh)":"(Sound)");				break;
			 case VFT2_DRV_COMM:		strcat(WorkStr,OptJ?"(ʐM)":"(Communication)");			break;
			 case VFT2_UNKNOWN:
			 default:																				break;
			}
			break;
		 case VFT_FONT:
			strcat(WorkStr,OptJ?"tHg":"Font");
			switch(ffiData->dwFileSubtype){
			 case VFT2_FONT_RASTER:		strcat(WorkStr,OptJ?"(X^)":"(Raster)");		break;
			 case VFT2_FONT_VECTOR:		strcat(WorkStr,OptJ?"(xN^)":"(Vector)");		break;
			 case VFT2_FONT_TRUETYPE:	strcat(WorkStr,OptJ?"(TrueType)":"(TrueType)");	break;
			 case VFT2_UNKNOWN:
			 default:																	break;
			}
			break;
		 case VFT_VXD:
			strcat(WorkStr,OptJ?"zfoCXhCo":"Virtual Device Driver");
			wsprintf(WorkStr+strlen(WorkStr),"(0x%08X)",ffiData->dwFileSubtype);
			break;
		 case VFT_STATIC_LIB:
			strcat(WorkStr,OptJ?"X^eBbNNCu":"Static Link Library");
			break;
		 case VFT_UNKNOWN:
		 default:
			strcat(WorkStr,OptJ?"s":"Unknown");
			break;
		}
		printf("%s\n",WorkStr);
	}
}

// o[W񂪑݂ꍇTRUEԋp
int StringFileInfo(char*name, BOOL bDisp)
{
	static char szName[512];	// 擾o[W̎w
	static char nameJ[512];

	if (!name || !*name){
		if (bDisp)	printf("\n");
		return FALSE;
	}
	wsprintf(szName, "%s%s", cStartBuf, name);
	if (VerQueryValue(lpData, szName, &lpBuffer, &wSize)){
		if (bDisp){
			if (OptJ){
				strcpy(nameJ, name);
					 if (!strcmp(name,"ProductName"))		strcpy(nameJ, "i");
				else if (!strcmp(name,"ProductVersion"))	strcpy(nameJ, "io[W");
				else if (!strcmp(name,"FileDescription"))	strcpy(nameJ, "t@C");
				else if (!strcmp(name,"FileVersion"))		strcpy(nameJ, "t@Co[W");
				else if (!strcmp(name,"LegalCopyright"))	strcpy(nameJ, "쌠m");
				else if (!strcmp(name,"CompanyName"))		strcpy(nameJ, "Ж");
				else if (!strcmp(name,"OriginalFilename"))	strcpy(nameJ, "IWit@C");
				else if (!strcmp(name,"InternalName"))		strcpy(nameJ, "t@C");
				else if (!strcmp(name,"Comments"))			strcpy(nameJ, "ǉ");
				else if (!strcmp(name,"LegalTrademarks"))	strcpy(nameJ, "Wm");
				else if (!strcmp(name,"PrivateBuild"))		strcpy(nameJ, "vCx[go[W");
				else if (!strcmp(name,"SpecialBuild"))		strcpy(nameJ, "Wo[WƂ̑");
				printf("%22s: %s\n",nameJ, lpBuffer);
			}else{
				printf("%16s: %s\n",name, lpBuffer);
			}
		}
		return TRUE;
	}
	return FALSE;
}

// ͋Z
void FindTranslation()
{
	wsprintf(cStartBuf, "\\StringFileInfo\\041103A4\\"); // {,{
	if (StringFileInfo("FileVersion", FALSE))		return;
	if (StringFileInfo("ProductVersion", FALSE))	return;
	wsprintf(cStartBuf, "\\StringFileInfo\\04111252\\"); // {,
	if (StringFileInfo("FileVersion", FALSE))		return;
	if (StringFileInfo("ProductVersion", FALSE))	return;
	wsprintf(cStartBuf, "\\StringFileInfo\\041104E4\\"); // {,
	if (StringFileInfo("FileVersion", FALSE))		return;
	if (StringFileInfo("ProductVersion", FALSE))	return;
	wsprintf(cStartBuf, "\\StringFileInfo\\08090000\\"); // pp,ASCII
	if (StringFileInfo("FileVersion", FALSE))		return;
	if (StringFileInfo("ProductVersion", FALSE))	return;
	wsprintf(cStartBuf, "\\StringFileInfo\\08091252\\"); // pp,
	if (StringFileInfo("FileVersion", FALSE))		return;
	if (StringFileInfo("ProductVersion", FALSE))	return;
	wsprintf(cStartBuf, "\\StringFileInfo\\080904E4\\"); // pp,
	if (StringFileInfo("FileVersion", FALSE))		return;
	if (StringFileInfo("ProductVersion", FALSE))	return;
	wsprintf(cStartBuf, "\\StringFileInfo\\04090000\\"); // čp,ASCII
	if (StringFileInfo("FileVersion", FALSE))		return;
	if (StringFileInfo("ProductVersion", FALSE))	return;
	wsprintf(cStartBuf, "\\StringFileInfo\\04091252\\"); // čp,
	if (StringFileInfo("FileVersion", FALSE))		return;
	if (StringFileInfo("ProductVersion", FALSE))	return;
	wsprintf(cStartBuf, "\\StringFileInfo\\040904E4\\"); // čp,
}

int ShowVerInfoFile(char*FileName)
{
	HGLOBAL hMem;
	DWORD   handle;			// o[W񎯕ʃnh
	DWORD   dwSize;			// o[W̃obt@TCY

	dwSize = GetFileVersionInfoSize(FileName, &handle);
	if (!dwSize){
		printf("  o[W񂪑݂܂\n");
		return -1;
	}
//	hMem = GlobalAlloc(GMEM_MOVEABLE, dwSize);			// SDK Help̋Lq
	hMem = GlobalAlloc(GMEM_ZEROINIT, dwSize + 100);	// Windows API ޲2̋Lq
	if (!hMem){
		printf("  ̊mۂɎs܂\n");
		return -2;
	}
	lpData = GlobalLock(hMem);
	GetFileVersionInfo(FileName, handle, dwSize, lpData);
	if (OptF)	RootFileInfo();
	VerQueryValue(lpData, "\\VarFileInfo\\Translation", (void**)&lpdwID, &wSize);

	if (lpdwID && 4==wSize){
		wsprintf(cStartBuf, "\\StringFileInfo\\%04X%04X\\", LOWORD(*lpdwID), HIWORD(*lpdwID));
		if (!StringFileInfo("FileVersion", FALSE))	FindTranslation();	// ͋Z
	}else{
		FindTranslation();	// ͋Z
	}

//	if (wSize!=0) {
		if (OptQ){
			StringFileInfo("ProductVersion");
			StringFileInfo("FileVersion");
		}else{
			StringFileInfo("ProductName");
			StringFileInfo("ProductVersion");
			StringFileInfo("FileDescription");
			StringFileInfo("FileVersion");
			StringFileInfo("LegalCopyright");
			StringFileInfo("CompanyName");
			if (OptV){
				StringFileInfo("OriginalFilename");
				StringFileInfo("InternalName");
				StringFileInfo("Comments");
				StringFileInfo("LegalTrademarks");
				StringFileInfo("PrivateBuild");
				StringFileInfo("SpecialBuild");
			}
		}
//	}

	GlobalUnlock(hMem);
	GlobalFree(hMem);
	return 0;
}

int ShowVerInfo(char*FileName)
{
	static char path[MAXPATH];
	static char pathname[MAXPATH];
	static char drive[MAXDRIVE];
	static char dir[MAXDIR];
	fnsplit(FileName,drive,dir,NULL,NULL);
	strcpy(path,drive);
	strcat(path,dir);
	struct ffblk ff;
	int attr = FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH;
	int done = findfirst(FileName, &ff, attr);
	if (done){
		printf("  %s܂\n",FileName);
		return -1;
	}
	while (!done){
		strcpy(pathname,path);
		strcat(pathname,ff.ff_name);
		printf("<<%s>>\n", pathname);
		if (-2==ShowVerInfoFile(pathname))	break;	// ̊mۂɎs
		done = findnext(&ff);
	}
	return 0;
}

//int PASCAL WinMain (HINSTANCE, HINSTANCE, LPSTR, int)
int main(int argc,char**argv)
{
	int fShowUsage = TRUE;

	for (int i=1; i<argc; i++){
		if ('/' == *argv[i] || '-' == *argv[i]){
			for (char* ch = &argv[i][1]; *ch; ch++){
				switch(*ch){
					case 'j': case 'J':		OptJ = !OptJ;	break;
					case 'f': case 'F':		OptF = !OptF;	break;
					case 'v': case 'V':		OptV = !OptV;	break;
					case 'q': case 'Q':		OptQ = !OptQ;	break;
				}
			}
		}else{
			fShowUsage = FALSE;
			ShowVerInfo(argv[i]);
		}
	}
	if (fShowUsage)	Usage();
	return 0;
}

