unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Menus;

const
  VerStr = 'WCW Watch 1.00'+#13+#10+'Copyright (C) 1997 y.ohm';

type
  TWCWWMain = class(TForm)
    Panel1: TPanel;
    Timer1: TTimer;
    PopupMenu1: TPopupMenu;
    Copy1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Panel1Resize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    StartTime: TDateTime;
    WindowCaptionList: TStringList;
    function IsExistWin: Boolean;
  public
  end;

var
  WCWWMain: TWCWWMain;

implementation

uses
  MMSystem,Clipbrd;

{$R *.DFM}

procedure TWCWWMain.FormCreate(Sender: TObject);
begin
  StartTime := Time;
  Left := 0;
  Top := 0;
  Hint := VerStr;
  WindowCaptionList := TStringList.Create;
  try
    WindowCaptionList.LoadFromFile(ChangeFileExt(ParamStr(0),'.wcw'));
  except
    //f[^t@CȂ
    with WindowCaptionList do begin
      Add('H/PC ւ̺߰ƕϊ...');
      Add('PC ւ̺߰ƕϊ...');
    end;
    //Ȃ0oCg̃t@CłĂ܂̂ŁAwith̊Oɏo
    WindowCaptionList.SaveToFile(ChangeFileExt(ParamStr(0),'.wcw'));
  end;
end;

procedure TWCWWMain.FormDestroy(Sender: TObject);
begin
  WindowCaptionList.Free;
end;

function TWCWWMain.IsExistWin: Boolean;
var
  c,n: Integer;
begin
  Result := False;
  c := WindowCaptionList.Count;
  if 0 < c then begin
    for n := 0 to c-1 do begin
      if 0 <> FindWindow(nil,PChar(WindowCaptionList[n])) then begin
        Result := True;
        Break;
      end;
    end;
  end;
end;

procedure TWCWWMain.Timer1Timer(Sender: TObject);
var
  H,M,S,MS: Word;
  E: Extended;
  C: TColor;
  Str,CS: string;
begin
  C := Panel1.Color;
  if IsExistWin then begin
    Panel1.Color := clWindow;
    DecodeTime(Time-StartTime, H,M,S,MS);
    E := (60*60*H) + (60*M) + S;
    if E < 0 then Panel1.Font.Color := clGreen
    else Panel1.Font.Color := clWindowText;
    //0.5bԊu'.'_ł
    if MS < 500 then CS := ' ' else CS := '.';
    Panel1.Caption := FloatToStr(E) + CS;
  end else begin
    Panel1.Color := clBtnFace;
    if C <> Panel1.Color then begin //vI
      PlaySound(PChar(ChangeFileExt(ParamStr(0),'.wav')),0,SND_ASYNC or SND_FILENAME);
      Str := Panel1.Caption;
      Str[Length(Str)] := '.';
      Panel1.Caption := Str;
    end;
    StartTime := Time;
  end;
end;

procedure TWCWWMain.Panel1Resize(Sender: TObject);
begin
  //pl̃TCYɃtHgTCY킹
  Panel1.Font.Height := -Panel1.Height;
end;

procedure TWCWWMain.Copy1Click(Sender: TObject);
var
  S: string;
  n: Integer;
begin
  S := Panel1.Caption;
  n := Pos('.', S);
  if 0 < n then Delete(S,n,1);
  ClipBoard.AsText := S;
end;

procedure TWCWWMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  ptClient,ptScreen: TPoint;
begin
  //Shift+F10ŉEj[|bvAbv
  if ([ssShift] = Shift) and (VK_F10 = Key) then begin
    ptClient.x := 0;
    ptClient.y := 0;
    ptScreen := ClientToScreen(ptClient);
    PopupMenu1.Popup(ptScreen.x,ptScreen.y);
  end;
  //Ctrl+InsertŃRs[
  if ([ssCtrl] = Shift) and (VK_INSERT = Key) then begin
    Copy1Click(Sender);
  end;
end;

end.
